<?php
use Livewire\Volt\Component;
use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\SRO_VT_SHARD\Inventory;
use App\Models\SRO_VT_SHARD\Items;
use App\Models\FastEventsTreasure;
use Illuminate\Support\Facades\Auth;
use App\Models\SRO_VT_PROXY\_InstantCharReloadDelivery;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

new class extends Component {
    // Facebook Events Section
    public $showFacebookSection = false;
    public $facebookPosts = [];
    public $collectedPoints = 0;
    public $uncollectedPoints = 0;
    public $collectedCount = 0;
    public $uncollectedCount = 0;
    public $acceptedCount = 0;
    public $pendingCount = 0;
    public $userStats = [];
    public $userFacebookLink = '';
    public $showFacebookLinkForm = false;

    // New Post Form Variables
    public $newPostLink = '';
    public $newPostActions = [];
    public $showPostHistory = false;

    // Treasure Section (existing)
    public $GiftDollarItemsID = [];
    public $GiftDollarIcon = 'https://4tressro.com/image/sro/4t/dollar_reward.jpg';
    public $UserChar = [];
    public $CharsInfo = [];
    public $avatarUrl = null;
    public $CharsHaveDollar = [];
    public $CharsTotalDollar = 0;
    public $CharTotalGiftBalance = 0;

    public $CharID = null;
    public $GiftDollarForChar = [];
    public $CharTotalDollar = 0;

    public function mount()
    {
        $this->loaddata();
        $this->checkFacebookLink();
        $this->loadFacebookPosts();
    }

    public function checkFacebookLink()
    {
        if (Auth::check() && Auth::user()->webUser) {
            $this->userFacebookLink = Auth::user()->webUser->facebook ?? '';
        }
    }

    public function loadFacebookPosts()
    {
        if (!Auth::check()) {
            $this->facebookPosts = [];
            $this->collectedPoints = 0;
            $this->uncollectedPoints = 0;
            $this->collectedCount = 0;
            $this->uncollectedCount = 0;
            $this->acceptedCount = 0;
            $this->pendingCount = 0;
            $this->userStats = [];
            return;
        }

        // جلب البيانات من قاعدة البيانات
        $dbPosts = FastEventsTreasure::forUser(Auth::user()->JID)
            ->orderBy('created_at', 'desc')
            ->get();

        $this->facebookPosts = $dbPosts->map(function($post) {
            return [
                'id' => $post->id,
                'link' => $post->link,
                'actions' => $this->getActionsFromBooleans($post->like, $post->comment, $post->share),
                'like' => $post->like,
                'comment' => $post->comment,
                'share' => $post->share,
                'points' => $post->total_points,
                'collected' => $post->collected,
                'collected_at' => $post->collected_at,
                'accepted' => $post->accepted,
                'accepted_by' => $post->accepted_by,
                'accepted_at' => $post->accepted_at
            ];
        })->toArray();

        // جلب الإحصائيات
        $this->userStats = FastEventsTreasure::getUserStats(Auth::user()->JID);
        $this->collectedPoints = $this->userStats['collected_points'];
        $this->uncollectedPoints = $this->userStats['uncollected_points'];

        // حساب عدد المشاركات المجمعة وغير المجمعة
        $this->collectedCount = $dbPosts->where('collected', true)->count();
        $this->uncollectedCount = $dbPosts->where('collected', false)->count();

        // حساب عدد المشاركات المقبولة والمعلقة
        $this->acceptedCount = $dbPosts->where('accepted', true)->count();
        $this->pendingCount = $dbPosts->where('accepted', false)->count();
    }

    private function getActionsFromBooleans($like, $comment, $share)
    {
        $actions = [];
        if ($like) $actions[] = 'like';
        if ($comment) $actions[] = 'comment';
        if ($share) $actions[] = 'share';
        return $actions;
    }

    public function toggleFacebookSection()
    {
        $this->showFacebookSection = !$this->showFacebookSection;
    }

    public function saveFacebookLink()
    {
        if (!Auth::check()) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please login first',
                'duration' => 2500,
            ]);
            return;
        }

        // التحقق من صحة الرابط
        if (empty($this->userFacebookLink)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please enter your Facebook profile link',
                'duration' => 2500,
            ]);
            return;
        }

        if (!filter_var($this->userFacebookLink, FILTER_VALIDATE_URL)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please enter a valid Facebook profile URL',
                'duration' => 2500,
            ]);
            return;
        }

        // التحقق من أن الرابط يحتوي على facebook.com
        if (!str_contains($this->userFacebookLink, 'facebook.com')) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please enter a valid Facebook profile URL',
                'duration' => 2500,
            ]);
            return;
        }

        try {
            $user = Auth::user();
            $user->webUser->facebook = $this->userFacebookLink;
            $user->webUser->save();

            $this->showFacebookLinkForm = false;

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => 'Facebook profile link saved successfully!',
                'duration' => 3000,
            ]);

            // إعادة تحميل البيانات
            $this->checkFacebookLink();

        } catch (\Exception $e) {
            \Log::error('Error saving Facebook link: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error saving Facebook link. Please try again.',
                'duration' => 2500,
            ]);
        }
    }

    public function submitNewPost()
    {
        if (!Auth::check()) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please login first',
                'duration' => 2500,
            ]);
            return;
        }

        // التحقق من صحة البيانات
        if (empty($this->newPostLink)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please enter post link',
                'duration' => 2500,
            ]);
            return;
        }

        if (!filter_var($this->newPostLink, FILTER_VALIDATE_URL)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please enter a valid URL',
                'duration' => 2500,
            ]);
            return;
        }

        if (empty($this->newPostActions)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please select at least one action',
                'duration' => 2500,
            ]);
            return;
        }

        // التحقق من عدم تكرار الرابط
        if (FastEventsTreasure::linkExists($this->newPostLink)) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'This link already exists in your posts',
                'duration' => 2500,
            ]);
            return;
        }

        try {
            // إنشاء مشاركة جديدة في قاعدة البيانات
            $newPost = FastEventsTreasure::create([
                'user_id' => Auth::user()->JID,
                'link' => $this->newPostLink,
                'like' => in_array('like', $this->newPostActions),
                'comment' => in_array('comment', $this->newPostActions),
                'share' => in_array('share', $this->newPostActions),
            ]);

            // إعادة تعيين النموذج
            $this->newPostLink = '';
            $this->newPostActions = [];

            // إعادة تحميل البيانات
            $this->loadFacebookPosts();

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => 'Post added successfully! It will be reviewed and you will receive points once approved.',
                'duration' => 4000,
            ]);

        } catch (\Exception $e) {
            \Log::error('Error adding Facebook post: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error adding post. Please try again.',
                'duration' => 2500,
            ]);
        }
    }

    public function showPostHistory()
    {
        $this->showPostHistory = !$this->showPostHistory;
    }

    public function removeFacebookPost($postId)
    {
        if (!Auth::check()) {
            return;
        }

        try {
            // التحقق من ملكية المشاركة
            $post = FastEventsTreasure::where('id', $postId)
                ->where('user_id', Auth::user()->JID)
                ->first();

            if (!$post) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Post not found or access denied',
                    'duration' => 2500,
                ]);
                return;
            }

            // التحقق من أن المنشور غير مقبول
            if ($post->accepted) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => __('general.cannotDeleteAccepted'),
                    'duration' => 3000,
                ]);
                return;
            }

            // حذف المشاركة
            $post->delete();

            // إعادة تحميل البيانات
            $this->loadFacebookPosts();

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => 'Post removed successfully!',
                'duration' => 2500,
            ]);

        } catch (\Exception $e) {
            \Log::error('Error removing Facebook post: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error removing post. Please try again.',
                'duration' => 2500,
            ]);
        }
    }

    public function updatePostAction($postId, $action)
    {
        if (!Auth::check()) {
            return;
        }

        try {
            // التحقق من ملكية المشاركة
            $post = FastEventsTreasure::where('id', $postId)
                ->where('user_id', Auth::user()->JID)
                ->first();

            if (!$post) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Post not found or access denied',
                    'duration' => 2500,
                ]);
                return;
            }

            // تبديل حالة النشاط (تفعيل/إلغاء) بدلاً من تفعيل واحد فقط
            switch($action) {
                case 'like':
                    $post->like = !$post->like;
                    break;
                case 'comment':
                    $post->comment = !$post->comment;
                    break;
                case 'share':
                    $post->share = !$post->share;
                    break;
            }

            // حفظ التغييرات (سيتم حساب النقاط تلقائياً)
            $post->save();

            // إعادة تحميل البيانات
            $this->loadFacebookPosts();

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => 'Action updated successfully!',
                'duration' => 2500,
            ]);

        } catch (\Exception $e) {
            \Log::error('Error updating Facebook post action: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error updating action. Please try again.',
                'duration' => 2500,
            ]);
        }
    }

    public function updatePostLink($postId, $link)
    {
        if (!Auth::check()) {
            return;
        }

        try {
            // التحقق من صحة الرابط
            if (!empty($link) && !filter_var($link, FILTER_VALIDATE_URL)) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Please enter a valid URL',
                    'duration' => 2500,
                ]);
                return;
            }

            // التحقق من عدم تكرار الرابط
            if (!empty($link) && FastEventsTreasure::linkExists($link, $postId)) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'This link already exists in your posts',
                    'duration' => 2500,
                ]);
                return;
            }

            // العثور على المشاركة وتحديثها
            $post = FastEventsTreasure::where('id', $postId)
                ->where('user_id', Auth::user()->JID)
                ->first();

            if (!$post) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Post not found or access denied',
                    'duration' => 2500,
                ]);
                return;
            }

            $post->link = $link;
            $post->save();

            // إعادة تحميل البيانات
            $this->loadFacebookPosts();

        } catch (\Exception $e) {
            \Log::error('Error updating Facebook post link: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error updating link. Please try again.',
                'duration' => 2500,
            ]);
        }
    }

    // دالة للتعامل مع تحديث الروابط من الـ wire:model
    public function updatedFacebookPosts($value, $key)
    {
        // تحليل المفتاح للحصول على index و property
        $keyParts = explode('.', $key);
        if (count($keyParts) >= 2) {
            $index = $keyParts[0];
            $property = $keyParts[1];

            if ($property === 'link' && isset($this->facebookPosts[$index])) {
                $postId = $this->facebookPosts[$index]['id'];
                $this->updatePostLink($postId, $value);
            }
        }
    }

    public function collectRewards()
    {
        if (!Auth::check()) {
            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Please login first',
                'duration' => 2500,
            ]);
            return;
        }

        try {
            // العثور على المشاركات غير المجمعة والمقبولة فقط
            $uncollectedPosts = FastEventsTreasure::forUser(Auth::user()->JID)
                ->uncollected()
                ->accepted() // فقط المشاركات المقبولة
                ->where('total_points', '>', 0)
                ->where('link', '!=', '') // التأكد من وجود رابط
                ->get();

            if ($uncollectedPosts->isEmpty()) {
                $this->dispatch('show-notification', [
                    'type' => 'warning',
                    'message' => 'No accepted rewards available to collect. Make sure posts are accepted first.',
                    'duration' => 3000,
                ]);
                return;
            }

            $totalPoints = $uncollectedPosts->sum('total_points');

            // بدء المعاملة
            \DB::beginTransaction();

            // تحديث رصيد المستخدم (تحويل النقاط إلى Gift Balance)
            $user = Auth::user();
            $giftBalanceToAdd = round($totalPoints / 5, 2); // كل 5 نقاط = 1 Gift Balance

            $user->webUser->gift_balance += $giftBalanceToAdd;
            $user->webUser->save();

            // تحديد المشاركات كمجمعة
            foreach ($uncollectedPosts as $post) {
                $post->markAsCollected();
            }

            \DB::commit();

            // إعادة تحميل البيانات
            $this->loadFacebookPosts();

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => "Successfully collected {$totalPoints} points = {$giftBalanceToAdd} Gift Balance!",
                'duration' => 4000,
            ]);

        } catch (\Exception $e) {
            \DB::rollback();
            \Log::error('Error collecting Facebook rewards: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'Error collecting rewards. Please try again.',
                'duration' => 2500,
            ]);
        }
    }



    public function loaddata()
    {
        try {
            // التحقق من تسجيل الدخول
            if (!Auth::check()) {
                return;
            }

            // جلب معرفات الشخصيات بطريقة محسنة
            $userCharIds = _User::where('UserJID', Auth::user()->JID)
                ->pluck('CharID')
                ->toArray();

            if (empty($userCharIds)) {
                return;
            }

            $this->UserChar = _User::where('UserJID', Auth::user()->JID)
                ->get()
                ->toArray();
            $this->CharsInfo = Char::whereIn('CharID', $userCharIds)->get()->toArray();

            // جلب معرفات عناصر الدولار
            $this->GiftDollarItemsID = Items::where('RefItemID', 92592)->pluck('ID64')->toArray();

            if (empty($this->GiftDollarItemsID)) {
                $this->CharsHaveDollar = [];
                $this->CharsTotalDollar = 0;
                return;
            }

            // جلب المخزون الذي يحتوي على دولارات
            $this->CharsHaveDollar = Inventory::whereIn('ItemID', $this->GiftDollarItemsID)
                ->whereIn('CharID', $userCharIds)
                ->with('item') // تحميل العلاقة مسبقاً
                ->get()
                ->toArray();

            // حساب إجمالي الدولارات
            $itemIds = collect($this->CharsHaveDollar)->pluck('ItemID')->toArray();
            $this->CharsTotalDollar = Items::whereIn('ID64', $itemIds)->sum('Data');
        } catch (\Exception $e) {
            \Log::error('Error in treasure-event loaddata: ' . $e->getMessage());
            $this->CharsTotalDollar = 0;
            $this->CharsHaveDollar = [];
        }
    }

    //Create Functions by sending  ID64s For Each Char And Update Items Set RefItemID = 92573 Where ID64 IN ID64s
    public function claimReward($CharID)
    {
        try {
            // التحقق من صحة البيانات
            if (!Auth::check()) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'User not authenticated.',
                    'duration' => 2500,
                ]);
                return;
            }

            // التحقق من وجود webUser
            $user = Auth::user();
            if (!$user->webUser) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Web user data not found.',
                    'duration' => 2500,
                ]);
                return;
            }

            $this->CharID = $CharID;

            // التحقق من ملكية الشخصية
            $isCharOwned = _User::where('UserJID', $user->JID)->where('CharID', $this->CharID)->exists();

            if (!$isCharOwned) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'Character does not belong to this user.',
                    'duration' => 2500,
                ]);
                return;
            }

            // جلب عناصر الدولار للشخصية
            $this->GiftDollarForChar = Inventory::whereIn('ItemID', $this->GiftDollarItemsID)->where('CharID', $this->CharID)->get()->toArray();

            if (empty($this->GiftDollarForChar)) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'No Dollar to claim for this character.',
                    'duration' => 2500,
                ]);
                return;
            }

            // حساب إجمالي الدولارات
            $itemIds = collect($this->GiftDollarForChar)->pluck('ItemID')->toArray();
            $this->CharTotalDollar = Items::whereIn('ID64', $itemIds)->sum('Data');

            //Reload Char _InstantCharReloadDelivery
            _InstantCharReloadDelivery::insertCharID($this->CharID);
            // CharTotalDollar Data 250 = 1 Gift Balance
            $this->CharTotalGiftBalance = round($this->CharTotalDollar / 250, 2);

            if ($this->CharTotalDollar <= 0) {
                $this->dispatch('show-notification', [
                    'type' => 'error',
                    'message' => 'No valid Dollar amount to claim.',
                    'duration' => 2500,
                ]);
                return;
            }

            // بدء المعاملة
            \DB::beginTransaction();

            // تحديث رصيد المستخدم
            $user->webUser->gift_balance += $this->CharTotalGiftBalance;
            $user->webUser->save();

            // تحديث عناصر الدولار (تحويلها إلى عناصر مستلمة)
            Items::whereIn('ID64', $itemIds)->update(['RefItemID' => 92573]);

            \DB::commit();

            // إعادة تحميل البيانات
            $this->loaddata();

            $this->dispatch('show-notification', [
                'type' => 'success',
                'message' => "Successfully claimed {$this->CharTotalGiftBalance} gift balance!",
                'duration' => 3000,
            ]);
        } catch (\Exception $e) {
            \DB::rollback();
            \Log::error('Error in claimReward: ' . $e->getMessage());

            $this->dispatch('show-notification', [
                'type' => 'error',
                'message' => 'An error occurred while claiming rewards.',
                'duration' => 2500,
            ]);
        }
    }
};
?>
<div x-data="{
    showFacebookSection: @entangle('showFacebookSection'),
    showPostHistory: @entangle('showPostHistory'),
    animateReward: false,

    toggleSection() {
        this.showFacebookSection = !this.showFacebookSection;
        if (this.showFacebookSection) {
            this.$nextTick(() => {
                this.$refs.facebookSection.scrollIntoView({ behavior: 'smooth' });
            });
        }
    },

    toggleHistory() {
        this.showPostHistory = !this.showPostHistory;
    },

    animateCounter() {
        this.animateReward = true;
        setTimeout(() => {
            this.animateReward = false;
        }, 500);
    }
}" class="treasure-event-container">

    <!-- Facebook Events Section -->
    <div class="facebook-events-section mb-8">
        <div class="facebook-intro-card">
            <div class="card-header">
                <div class="fb-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                    </svg>
                </div>
                <div class="header-content">
                    <h3 class="section-title" data-translate="treasureEvent.facebook.title">
                        Facebook Events Participation
                    </h3>
                    <p class="section-subtitle" data-translate="treasureEvent.facebook.subtitle">
                        Join our Facebook events and earn rewards for your engagement
                    </p>
                </div>
            </div>

            <div class="intro-button-container">
                <button
                    @click="toggleSection()"
                    class="facebook-subscribe-btn"
                    :class="{ 'active': showFacebookSection }"
                >
                    <span class="btn-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </span>
                    <span class="btn-text" data-translate="treasureEvent.facebook.subscribeBtn">
                        I have subscribed to Facebook events
                    </span>
                    <span class="btn-arrow" :class="{ 'rotated': showFacebookSection }">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                        </svg>
                    </span>
                </button>
            </div>
        </div>

        <!-- Facebook Events Form -->
        <div
            x-show="showFacebookSection"
            x-transition:enter="transition ease-out duration-500"
            x-transition:enter-start="opacity-0 transform -translate-y-10"
            x-transition:enter-end="opacity-100 transform translate-y-0"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100 transform translate-y-0"
            x-transition:leave-end="opacity-0 transform -translate-y-10"
            x-ref="facebookSection"
            class="facebook-form-container"
        >
            <!-- Facebook Profile Link Check -->
            @if(empty($this->userFacebookLink))
                <div class="facebook-setup-required">
                    <div class="setup-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </div>
                    <div class="setup-content">
                        <h4 data-translate="treasureEvent.facebook.setupRequired">Facebook Profile Required</h4>
                        <p data-translate="treasureEvent.facebook.setupDescription">
                            To participate in Facebook events and earn rewards, you need to add your Facebook profile link first. This helps us verify your posts and calculate your rewards accurately.
                        </p>

                        <div class="setup-steps">
                            <div class="step">
                                <span class="step-number">1</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step1">Go to your Facebook profile</span>
                            </div>
                            <div class="step">
                                <span class="step-number">2</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step2">Copy your profile URL</span>
                            </div>
                            <div class="step">
                                <span class="step-number">3</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step3">Paste it in the field below</span>
                            </div>
                        </div>

                        <div class="facebook-link-form" x-data="{ showForm: @entangle('showFacebookLinkForm') }">
                            <button
                                @click="showForm = true"
                                x-show="!showForm"
                                class="setup-btn"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.addProfile">Add Facebook Profile</span>
                            </button>

                            <div x-show="showForm" x-transition class="facebook-form">
                                <div class="form-group">
                                    <label data-translate="treasureEvent.facebook.profileUrl">Facebook Profile URL</label>
                                    <input
                                        type="url"
                                        wire:model="userFacebookLink"
                                        placeholder="https://facebook.com/your-profile"
                                        class="form-input"
                                    >
                                </div>
                                <div class="form-actions">
                                    <button
                                        wire:click="saveFacebookLink"
                                        class="save-btn"
                                        wire:loading.attr="disabled"
                                    >
                                        <span wire:loading.remove>
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                            </svg>
                                            <span data-translate="general.save">Save</span>
                                        </span>
                                        <span wire:loading>
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                                <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                            </svg>
                                            <span data-translate="general.saving">Saving...</span>
                                        </span>
                                    </button>
                                    <button
                                        @click="showForm = false"
                                        class="cancel-btn"
                                    >
                                        <span data-translate="general.cancel">Cancel</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <!-- Facebook Profile Confirmed - Show Events Content -->
                <div class="facebook-profile-confirmed">
                    <div class="profile-info">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="text-success">
                            <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.profileLinked">Facebook Profile Linked:</span>
                        <a href="{{ $this->userFacebookLink }}" target="_blank" class="profile-link">
                            {{ Str::limit($this->userFacebookLink, 50) }}
                        </a>
                        <button
                            wire:click="$set('showFacebookLinkForm', true)"
                            class="edit-profile-btn"
                            title="Edit Profile Link"
                        >
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/>
                            </svg>
                        </button>
                    </div>

                    <!-- Edit Profile Form -->
                    @if($this->showFacebookLinkForm)
                    <div class="edit-profile-form" x-transition>
                        <div class="form-group">
                            <label data-translate="treasureEvent.facebook.profileUrl">Facebook Profile URL</label>
                            <input
                                type="url"
                                wire:model="userFacebookLink"
                                placeholder="https://facebook.com/your-profile"
                                class="form-input"
                            >
                        </div>
                        <div class="form-actions">
                            <button
                                wire:click="saveFacebookLink"
                                class="save-btn"
                                wire:loading.attr="disabled"
                            >
                                <span wire:loading.remove>
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                    </svg>
                                    <span data-translate="general.save">Save</span>
                                </span>
                                <span wire:loading>
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                        <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                    </svg>
                                    <span data-translate="general.saving">Saving...</span>
                                </span>
                            </button>
                            <button
                                wire:click="$set('showFacebookLinkForm', false)"
                                class="cancel-btn"
                            >
                                <span data-translate="general.cancel">Cancel</span>
                            </button>
                        </div>
                    </div>
                    @endif
                </div>

            @endif

            @if(!empty($this->userFacebookLink))
            <!-- Warning Notice -->
            <div class="warning-notice">
                <div class="warning-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/>
                    </svg>
                </div>
                <div class="warning-content">
                    <h5 data-translate="treasureEvent.facebook.warningTitle">Important Notice</h5>
                    <p data-translate="treasureEvent.facebook.warningText">
                        Rewards calculation applies only to posts starting from September 11, 2025
                    </p>
                </div>
            </div>

            <!-- Rewards Counter -->
            <div class="rewards-counter-card">
                <div class="counter-header">
                    <h4 data-translate="treasureEvent.facebook.rewardsCalculator">Rewards Calculator</h4>
                </div>
                <div class="counter-display">
                    <div class="counter-value" :class="{ 'animate-pulse': animateReward }">
                        <span class="value-number">{{ $this->userStats['total_points'] ?? 0 }}</span>
                        <span class="value-label" data-translate="treasureEvent.facebook.points">Points</span>
                    </div>
                </div>
                <div class="points-breakdown">
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.like">Like</span>
                        <span class="points">5 pts</span>
                    </div>
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.comment">Comment</span>
                        <span class="points">7 pts</span>
                    </div>
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.share">Share</span>
                        <span class="points">13 pts</span>
                    </div>
                </div>
            </div>

            <!-- Statistics Section -->
            <div class="statistics-section">
                <div class="stats-header">
                    <h4 data-translate="treasureEvent.facebook.statistics">Your Statistics</h4>
                </div>
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon total">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.total_posts">Total Posts</span>
                            <span class="stat-value">{{ count($this->facebookPosts) }}</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon collected">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.collected_rewards">Collected</span>
                            <span class="stat-value text-success">{{ $this->collectedCount }}</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon pending">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>
                                <path d="M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.pending_rewards">Pending</span>
                            <span class="stat-value text-warning">{{ $this->uncollectedCount }}</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon accepted">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.accepted_posts">Accepted</span>
                            <span class="stat-value text-info">{{ $this->acceptedCount }}</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon pending-approval">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm0-9V11l-4 4-4-4V7.5l4-4 4 4zM8 4h8v3.5L12 11.5 8 7.5V4z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.pending_approval">Pending Approval</span>
                            <span class="stat-value text-secondary">{{ $this->pendingCount }}</span>
                        </div>
                    </div>
                </div>

                <div class="points-grid">
                    <div class="points-card collected-points">
                        <div class="points-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4.64 6.8c-.15 1.58-.08 2.94-.56 4.1-.63 1.5-1.65 2.63-2.74 3.73-.84.84-1.73 1.64-2.57 2.51-.42.44-.85.87-1.31 1.27-.15.13-.3.26-.45.37-.08.06-.15.11-.23.17-.04.03-.08.05-.12.07-.02.01-.04.02-.05.03-.01 0-.02.01-.02.01-.01 0-.01 0-.02-.01-.01-.01-.02-.02-.04-.03-.04-.02-.08-.04-.12-.07-.08-.06-.15-.11-.23-.17-.15-.11-.3-.24-.45-.37-.46-.4-.89-.83-1.31-1.27-.84-.87-1.73-1.67-2.57-2.51-1.09-1.1-2.11-2.23-2.74-3.73-.48-1.16-.41-2.52-.56-4.1C6.35 7.8 6.8 6.9 7.12 6.2c.16-.35.3-.7.4-1.06.05-.18.08-.36.1-.54.01-.09.01-.18.01-.27 0-.04 0-.08-.01-.12 0-.02 0-.04-.01-.06 0-.01 0-.02 0-.02 0 0 0-.01.01-.02.01-.01.02-.02.04-.03.04-.02.08-.04.12-.07.08-.06.15-.11.23-.17.15-.11.3-.24.45-.37.46-.4.89-.83 1.31-1.27.84-.87 1.73-1.67 2.57-2.51 1.09-1.1 2.11-2.23 2.74-3.73.48-1.16.41-2.52.56-4.1.01-.09.03-.17.04-.26.02-.17.04-.34.08-.5.08-.32.19-.63.33-.93.28-.6.67-1.15 1.12-1.63.23-.24.48-.46.75-.66.14-.1.28-.19.43-.28.08-.05.15-.09.23-.13.04-.02.08-.04.12-.06.02-.01.04-.02.05-.02.01-.01.02-.01.03-.01.01 0 .02 0 .03.01.01 0 .03.01.05.02.04.02.08.04.12.06.08.04.15.08.23.13.15.09.29.18.43.28.27.2.52.42.75.66.45.48.84 1.03 1.12 1.63.14.3.25.61.33.93.04.16.06.33.08.5.01.09.03.17.04.26z"/>
                            </svg>
                        </div>
                        <div class="points-content">
                            <span class="points-label" data-translate="total_collected_points">Collected Points</span>
                            <span class="points-value">{{ $this->collectedPoints }}</span>
                        </div>
                    </div>
                    <div class="points-card pending-points">
                        <div class="points-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm0-9V11l-4 4-4-4V7.5l4-4 4 4zM8 4h8v3.5L12 11.5 8 7.5V4z"/>
                            </svg>
                        </div>
                        <div class="points-content">
                            <span class="points-label" data-translate="pending_points">Pending Points</span>
                            <span class="points-value">{{ $this->uncollectedPoints }}</span>
                        </div>
                    </div>
                </div>

                @php
                    $acceptedUncollectedPoints = collect($this->facebookPosts)
                        ->where('accepted', true)
                        ->where('collected', false)
                        ->sum('points');
                @endphp

                @if($acceptedUncollectedPoints > 0)
                <div class="collect-section">
                    <div class="collect-info">
                        <span data-translate="treasureEvent.facebook.collectInfo">
                            You can collect {{ $acceptedUncollectedPoints }} points = {{ round($acceptedUncollectedPoints / 5, 2) }} Gift Balance
                        </span>
                    </div>
                    <button
                        wire:click="collectRewards"
                        class="collect-rewards-btn"
                        wire:loading.attr="disabled"
                        wire:loading.class="loading">
                        <span wire:loading.remove>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20 6h-2.18c.11-.31.18-.65.18-1a2.996 2.996 0 0 0-5.5-1.65l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1z"/>
                            </svg>
                            <span data-translate="general.collect_rewards">Collect Rewards</span>
                        </span>
                        <span wire:loading>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                            </svg>
                            <span data-translate="general.collecting">Collecting...</span>
                        </span>
                    </button>
                </div>
                @endif
            </div>

            <!-- Posts Management -->
            <div class="posts-management">
                <div class="section-header">
                    <h4 data-translate="treasureEvent.facebook.managePosts">Submit New Post</h4>
                    <button @click="toggleHistory()" class="history-btn" :class="{ 'active': showPostHistory }">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" class="history-icon" x-show="!showPostHistory">
                            <path d="M13 3a9 9 0 0 0-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.954 8.954 0 0 0 13 21a9 9 0 0 0 0-18zm-1 5v5l4.25 2.52.77-1.28-3.52-2.09V8z"/>
                        </svg>
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" class="close-icon" x-show="showPostHistory">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z"/>
                        </svg>
                        <span class="btn-text">
                            <span x-show="!showPostHistory" data-translate="treasureEvent.facebook.showHistory">Show History</span>
                            <span x-show="showPostHistory" data-translate="treasureEvent.facebook.hideHistory">Hide History</span>
                        </span>
                        <span class="btn-arrow" :class="{ 'rotated': showPostHistory }">
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                            </svg>
                        </span>
                    </button>
                </div>

                <!-- New Post Form -->
                <div class="new-post-form" x-data="{
                    postLink: @entangle('newPostLink'),
                    selectedActions: @entangle('newPostActions'),
                    calculatePoints() {
                        let points = 0;
                        if (this.selectedActions.includes('like')) points += 5;
                        if (this.selectedActions.includes('comment')) points += 7;
                        if (this.selectedActions.includes('share')) points += 13;
                        return points;
                    }
                }">
                    <div class="form-group">
                        <label data-translate="treasureEvent.facebook.postLink">Post Link</label>
                        <input
                            type="url"
                            x-model="postLink"
                            placeholder="https://facebook.com/..."
                            class="form-input"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label data-translate="treasureEvent.facebook.actionType">Select Actions (you can select multiple)</label>
                        <div class="action-buttons">
                            <button
                                @click="
                                    if (selectedActions.includes('like')) {
                                        selectedActions = selectedActions.filter(a => a !== 'like');
                                    } else {
                                        selectedActions.push('like');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('like') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.like">Like</span>
                                <span class="points">5</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('like')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>

                            <button
                                @click="
                                    if (selectedActions.includes('comment')) {
                                        selectedActions = selectedActions.filter(a => a !== 'comment');
                                    } else {
                                        selectedActions.push('comment');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('comment') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.comment">Comment</span>
                                <span class="points">7</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('comment')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>

                            <button
                                @click="
                                    if (selectedActions.includes('share')) {
                                        selectedActions = selectedActions.filter(a => a !== 'share');
                                    } else {
                                        selectedActions.push('share');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('share') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.share">Share</span>
                                <span class="points">13</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('share')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <div class="post-points-preview">
                        <span class="points-display">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                            </svg>
                            <span class="points-value" x-text="calculatePoints()"></span>
                            <span class="points-label" data-translate="treasureEvent.facebook.points">Points</span>
                        </span>
                    </div>

                    <div class="form-actions">
                        <button
                            wire:click="submitNewPost"
                            @click="animateCounter()"
                            class="submit-post-btn"
                            wire:loading.attr="disabled"
                            :disabled="!postLink || selectedActions.length === 0"
                        >
                            <span wire:loading.remove>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.addPost">Add Post</span>
                            </span>
                            <span wire:loading>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                    <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                </svg>
                                <span data-translate="general.adding">Adding...</span>
                            </span>
                        </button>
                    </div>
                </div>
  <div class="history-header">
                        <h5 data-translate="treasureEvent.facebook.postHistory">Post History</h5>
                        <button @click="toggleHistory()" class="close-history-btn">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                            </svg>
                        </button>
                    </div>
                <!-- Post History Section -->
                <div
                    x-show="showPostHistory"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 transform -translate-y-10"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-10"
                    class="post-history-section"
                >
                    <div class="history-list">
                        @forelse($facebookPosts as $index => $post)
                            <div class="history-item">
                                <div class="history-header-item">
                                    <span class="post-number">#{{ $index + 1 }}</span>
                                    <div class="post-status">
                                        @if($post['collected'])
                                            <span class="status-indicator collected">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                                </svg>
                                                <span data-translate="general.collected">Collected</span>
                                            </span>
                                        @elseif($post['accepted'])
                                            <span class="status-indicator accepted">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                                </svg>
                                                <span data-translate="general.accepted">Accepted</span>
                                            </span>
                                        @else
                                            <span class="status-indicator pending">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>
                                                    <path d="M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                                </svg>
                                                <span data-translate="general.pending">Pending</span>
                                            </span>
                                        @endif
                                    </div>
                                    @if(!$post['accepted'])
                                        <button
                                            wire:click="removeFacebookPost('{{ $post['id'] }}')"
                                            class="remove-btn"
                                            title="Delete Post"
                                        >
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
                                            </svg>
                                        </button>
                                    @else
                                        <span class="accepted-badge" title="Accepted posts cannot be deleted">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M18,8A2,2 0 0,1 20,10V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V10A2,2 0 0,1 6,8H7V6A5,5 0 0,1 12,1A5,5 0 0,1 17,6V8H18M12,3A3,3 0 0,0 9,6V8H15V6A3,3 0 0,0 12,3Z"/>
                                            </svg>
                                        </span>
                                    @endif
                                </div>

                                <div class="history-content">
                                    <div class="post-link">
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H6.5C3.56 7 1 9.56 1 12.5S3.56 18 6.5 18H11v-1.9H6.5c-1.71 0-3.1-1.39-3.1-3.1zM8 13h8v-2H8v2zm9.5-6H13v1.9h4.5c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1H13V18h4.5c2.94 0 5.5-2.56 5.5-5.5S20.44 7 17.5 7z"/>
                                        </svg>
                                        <a href="{{ $post['link'] }}" target="_blank" class="link-text">
                                            {{ Str::limit($post['link'], 60) }}
                                        </a>
                                    </div>

                                    <div class="post-actions-history">
                                        @if($post['like'])
                                            <span class="action-badge like">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                                </svg>
                                                <span>Like (5 pts)</span>
                                            </span>
                                        @endif
                                        @if($post['comment'])
                                            <span class="action-badge comment">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                                                </svg>
                                                <span>Comment (7 pts)</span>
                                            </span>
                                        @endif
                                        @if($post['share'])
                                            <span class="action-badge share">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                                                </svg>
                                                <span>Share (13 pts)</span>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="post-meta">
                                        <span class="points-info">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                                            </svg>
                                            {{ $post['points'] }} Points
                                        </span>
                                        @if($post['accepted_at'])
                                            <span class="date-info">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"/>
                                                </svg>
                                                {{ \Carbon\Carbon::parse($post['accepted_at'])->format('M d, Y H:i') }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="empty-history">
                                <div class="empty-icon">
                                    <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M13 3a9 9 0 0 0-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.954 8.954 0 0 0 13 21a9 9 0 0 0 0-18zm-1 5v5l4.25 2.52.77-1.28-3.52-2.09V8z"/>
                                    </svg>
                                </div>
                                <p data-translate="treasureEvent.facebook.noHistory">No posts in history yet.</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Existing Treasure Section -->
    <div class="treasure-section"
         x-show="!showFacebookSection || (showFacebookSection && $refs.facebookSection)"
    >
        @if ($CharsTotalDollar > 0)
            <div class="alert alert-success">
                <h4>Available Treasure: {{ $CharsTotalDollar }} 4T Dollar (Gift)</h4>
                <p>You have {{ count($CharsHaveDollar) }} treasure items to claim.</p>
            </div>
        @else
            <div class="alert alert-info">
                <p>No treasure items available to claim at the moment.</p>
            </div>
        @endif

        @if (!empty($CharsInfo))
            <div class="characters-list">
                <h5>Your Characters:</h5>
                @foreach ($CharsInfo as $char)
                    @php
                        $charDollarItems = collect($CharsHaveDollar)->where('CharID', $char['CharID']);
                        $charDollarAmount = 0;
                        if ($charDollarItems->count() > 0) {
                            $charItemIds = $charDollarItems->pluck('ItemID')->toArray();
                            $charDollarAmount = App\Models\SRO_VT_SHARD\Items::whereIn('ID64', $charItemIds)->sum(
                                'Data',
                            );
                        }
                    @endphp

                    <div class="character-card">
                        <h6>{{ $char['CharName16'] ?? 'Unknown' }}</h6>
                        <p>Available Dollars: {{ $charDollarAmount }}</p>
                        <p>Available Gift Balance: {{ round($charDollarAmount / 250, 2) }}</p>

                        @if ($charDollarAmount > 0)
                            <button wire:click="claimReward({{ $char['CharID'] }})" class="btn btn-primary">
                                Claim {{ $charDollarAmount }} Gift Balance
                            </button>
                        @else
                            <span class="text-muted">No dollars to claim</span>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
